document.addEventListener("DOMContentLoaded", () => {
    const toggleSpeech = document.getElementById("toggleSpeech");
    const speedInput = document.getElementById("speed");
    const voiceSelect = document.getElementById("voiceSelect");
    const darkModeToggle = document.getElementById("darkModeToggle");
    const wordsToggle = document.getElementById("wordsToggle");
    const saveBtn = document.getElementById("saveBtn");
    
    chrome.storage.sync.get(["enabled", "speed", "voice", "darkMode", "wordMode"], (data) => {
        toggleSpeech.checked = data.enabled ?? true;
        speedInput.value = data.speed ?? 1.0;
        darkModeToggle.checked = data.darkMode ?? false;
        wordsToggle.checked = data.wordMode ?? false;
        applyDarkMode(darkModeToggle.checked);
        loadVoices(data.voice);
    });

    saveBtn.addEventListener("click", () => {
        chrome.storage.sync.set({
            enabled: toggleSpeech.checked,
            speed: parseFloat(speedInput.value),
            voice: voiceSelect.value,
            darkMode: darkModeToggle.checked,
            wordMode: wordsToggle.checked
        }, () => {
            alert("Settings saved! Reload the page!");
        });
    });

    darkModeToggle.addEventListener("change", () => {
        applyDarkMode(darkModeToggle.checked);
        chrome.storage.sync.set({ darkMode: darkModeToggle.checked });
    });

    wordsToggle.addEventListener("change", () => {
        chrome.storage.sync.set({ wordMode: wordsToggle.checked });
    });

    function applyDarkMode(isDark) {
        document.body.classList.toggle("dark-mode", isDark);
    }

    function loadVoices(selectedVoice) {
        const voices = window.speechSynthesis.getVoices();
        voiceSelect.innerHTML = "";

        voices.forEach((voice) => {
            const option = document.createElement("option");
            option.value = voice.name;
            option.textContent = `${voice.name} (${voice.lang})`;
            voiceSelect.appendChild(option);
        });

        if (selectedVoice) {
            voiceSelect.value = selectedVoice;
        }
    }

    window.speechSynthesis.onvoiceschanged = () => loadVoices(voiceSelect.value);
});