let currentWord = "";
let synth = window.speechSynthesis;
let enabled = true;
let speechRate = 1.0;
let dictionary = new Set();
let wordsMode = false;
let dictionaryLoaded = false;
let settingsLoaded = false;

fetch(chrome.runtime.getURL("words_dictionary.json"))
    .then(response => {
        if (!response.ok) throw new Error(`HTTP error! Status: ${response.status}`);
        return response.json();
    })
    .then(words => {
        console.log("Dictionary Loaded");
        dictionary = new Set(Object.keys(words));
        dictionaryLoaded = true;
    })
    .catch(error => console.error("Failed to load dictionary:", error));


chrome.storage.sync.get(["enabled", "speed", "wordMode", "voice"], (data) => {
    enabled = data.enabled ?? true;
    speechRate = data.speed ?? 1.0;
    wordsMode = data.wordMode ?? false;
    settingsLoaded = true;
});


chrome.storage.onChanged.addListener((changes) => {
    if (changes.enabled) enabled = changes.enabled.newValue;
    if (changes.speed) speechRate = changes.speed.newValue;
    if (changes.wordMode) wordsMode = changes.wordMode.newValue;
});


let voices = [];
function loadVoices() {
    voices = synth.getVoices();
}
synth.onvoiceschanged = loadVoices;
loadVoices();

function speak(text) {
    if (enabled && settingsLoaded) {
        chrome.storage.sync.get("voice", (data) => {
            let utterance = new SpeechSynthesisUtterance(text);
            utterance.rate = speechRate;

            let selectedVoice = voices.find(voice => voice.name === data.voice);
            if (selectedVoice) {
                utterance.voice = selectedVoice;
            }

            synth.speak(utterance);
        });
    }
}

document.addEventListener("keydown", (event) => {
    const focusedElement = document.activeElement;
    if (focusedElement.type === "password") {
        return;
    }

    if (event.key.length === 1 && event.key.match(/[a-zA-Z]/)) {
        currentWord += event.key;

        if (!wordsMode) {
            speak(event.key.toUpperCase());
        }
    } else if (event.key === " " || event.key === "Enter" || event.key.match(/[\.\,\!\?]/)) {
        if (currentWord.length > 0 && dictionaryLoaded) {
            if (dictionary.has(currentWord.toLowerCase())) {
                speak(currentWord);
            }
            currentWord = "";
        }
    } else if (event.key === "Backspace") {
        currentWord = currentWord.slice(0, -1);
    }
});